<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>
    <div id="auth">
        <div class="row h-100">
            <div class="col-lg-5 col-12">
                <div id="auth-left">
                    <div class="auth-logo mt-5">
                        <center>
                            <a>
                                <img src="<?php echo e(getLogo()['logo']); ?>" class="logoSize" alt="Logo" />
                            </a>
                        </center>
                    </div>
                    <span class="d-none d-lg-block saprator"></span>
                    <?php if($social->google_on_off ?? '' == 'on'): ?>
                        <div class="mb-3 d-flex align-items-center justify-content-center">
                            <a href="<?php echo e(URL::to('/google/login')); ?>" class="login-with-google-btn rounded-pill my-auto">
                                <?php echo e(trans('site.login.google-with-login')); ?>

                            </a>
                        </div>
                    <?php endif; ?>

                    <form id="FromID" data-urlinsert="<?php echo e(route('login.custom')); ?>">
                        <div class="form-group position-relative has-icon-left mb-4 mt-5    ">
                            <input type="text" class="form-control form-control-xl"
                                placeholder="<?php echo e(trans('site.login.email')); ?>" name="email" />
                            <div class="form-control-icon">
                                <i class="bi bi-envelope ps-2"></i>
                            </div>
                            <span class="text-danger error-text email_error"></span>

                        </div>
                        <div class="form-group position-relative has-icon-left mb-4">
                            <input type="password" class="form-control form-control-xl" id="password"
                                placeholder="<?php echo e(trans('site.login.password')); ?>" name="password" />
                            <div class="form-control-icon">
                                <i class="bi bi-shield-lock ps-2"></i>
                            </div>
                            <span class="text-danger error-text password_error"></span>

                            <div class="row px-3 mt-2">
                                <div class="col-12 pe-0 form-check form-switch mt-2">
                                    <input class="form-check-input me-2" type="checkbox" id="show-password">
                                    <span id="passmsg"><?php echo e(trans('site.login.show-password')); ?></span>
                                </div>
                                <span class="text-danger error-text password_error"></span>
                              
                                <div class="col-12 form-check form-check-lg d-flex flex-nowrap align-items-center">
                                    <input class="form-check-input me-2" type="checkbox" name="remember_me"
                                        id="remember_me" value="1">
                                    <label class="form-check-label fs-7 text-gray-600" for="remember_me">
                                        <?php echo e(trans('site.login.remember-me')); ?>

                                    </label>
                                </div>
                              

                                <div class="col-12 form-check form-check-lg d-flex flex-nowrap align-items-center">
                                    <input class="form-check-input termscondition me-2" type="checkbox"
                                        name="terms_and_conditions_privacy_policy" id="flexCheckDefault">
                                    <label class="form-check-label fs-7 text-gray-600" for="flexCheckDefault">
                                        I agree to <?php echo e(env('APP_NAME')); ?> <a href="javascript:vad(0)" data-bs-toggle="modal"
                                            class="TermsPrivacy" data-bs-target="#TermsPrivacy" data-name="terms"
                                            data-urlinsert="<?php echo e(route('TermsAndConditionsGet')); ?>">Terms &
                                            Conditions</a> and <a href="javascript:vad(0)" class="TermsPrivacy"
                                            data-bs-toggle="modal" data-bs-target="#TermsPrivacy" data-name="privacy"
                                            data-urlinsert="<?php echo e(route('TermsAndConditionsGet')); ?>">Privacy Policy</a>
                                    </label>
                                </div>
                            </div>
                            <span class="text-danger error-text terms_and_conditions_privacy_policy_error"></span>

                        </div>
                        
                        <?php echo csrf_field(); ?>
                        <center><span id="loginSuccess"></span></center>
                        <button type="submit" id="login" class="btn btn-primary btn-block btn-lg shadow-lg mt-3">
                            <?php echo e(trans('site.login.login-button')); ?>

                        </button>
                    </form>

                    <div class="text-center mt-5 text-lg fs-6">
                        <p class="text-gray-600">
                            <?php echo e(trans('site.login.registration-info')); ?>

                            <a href="<?php echo e(route('register-user')); ?>"
                                class="font-bold"><?php echo e(trans('site.login.registration-link')); ?></a>
                        </p>
                        <p>
                            <a class="font-bold" href="<?php echo e(route('login.forgotPassword')); ?>">Forgot password?</a>
                        </p>
                        <?php echo e(trans('site.Version')); ?> <?php echo e(getLogo()['version']); ?>

                    </div>
                </div>
            </div>

            <?php if(!empty($social->emailCleaner)): ?>
            <div class="col-lg-7 my-auto">
                <div class="row col-lg-5 mx-auto">
                    <h5 class="validation-heading mb-4">Give it a shot. Validate an email address!
                    </h5>
                    <form id="FromIDs" data-urlinsert="<?php echo e(route('VerifyEmailAddress')); ?>">
                        <center>
                            <input type="email" name="CheckEmail"
                                class="form-control form-control-xl email-verification-demo shadow-sm mb-2">
                            <span class="fs-6 text-de" id="msgCheckMail"></span>
                        </center>
                        <center>
                            <button type="submit" id="VerifyEmail"
                                class="btn btn-primary btn-block btn-lg shadow-lg mt-3 w-fc mx-auto mb-5">Validate
                            </button>
                        </center>
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
            <?php else: ?>
            <div class="col-lg-7 my-auto">
                <div class="row col-lg-5 mx-auto">
                    <img src="<?php echo e(getLogo()['logo']); ?>" class="logoSize" alt="Logo" />
                </div>
            </div>


                
            <?php endif; ?>
        </div>
    </div>
    <?php echo $__env->make('auth.terms-and-conditions-privacy-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/BACKUP/repo/mailtidy/resources/views/auth/login.blade.php ENDPATH**/ ?>