<?php $__env->startSection('template_title'); ?>
    <?php echo e(trans('installer_messages.purchase_code.templateTitle')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e(trans('installer_messages.purchase_code.title')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('container'); ?>
    <?php if(\Session::has('msg')): ?>
        <div class="alert alert-danger">
            <ul>
                <li><?php echo \Session::get('msg'); ?></li>
            </ul>
        </div>
    <?php endif; ?>

    <div class="alert alert-danger alert-block msgStatus d-none" >
        <button type="button" class="close" data-dismiss="alert">×</button>
    </div>
    <form method="post" action="<?php echo e(route('LaravelInstaller::verifyPurchaseCode')); ?>" class="tabs-wrap">
        <?php echo csrf_field(); ?>
        <div class="box box-primary borderless">
            <div class="row">
                <div class="col-md-6">
                    <div class="skin-box-card">
                        <!-- section start -->
                        <div class="box-header">
                            <h3 class="box-title">Site Information</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group <?php echo e($errors->has('name') ? ' has-error ' : ''); ?>">
                                        <label for="name">
                                            <?php echo e(trans('installer_messages.purchase_code.buyer_name')); ?>

                                        </label>
                                        <input type="text" name="name" id="name"
                                            class="form-control has-help-text" value="<?php echo e(old('name')); ?>"
                                            placeholder="<?php echo e(trans('installer_messages.purchase_code.buyer_name_placeholder')); ?>" />
                                        <?php if($errors->has('name')): ?>
                                            <span class="error-block">
                                                <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                                                <?php echo e($errors->first('name')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group <?php echo e($errors->has('email') ? ' has-error ' : ''); ?>">
                                        <label for="email">
                                            <?php echo e(trans('installer_messages.purchase_code.buyer_email')); ?>

                                        </label>
                                        <input type="text" name="email" id="email" value="<?php echo e(old('email')); ?>"
                                            placeholder="<?php echo e(trans('installer_messages.purchase_code.buyer_email_placeholder')); ?>" />
                                        <?php if($errors->has('email')): ?>
                                            <span class="error-block">
                                                <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                                                <?php echo e($errors->first('email')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group <?php echo e($errors->has('purchase_code') ? ' has-error ' : ''); ?>">
                                        <label for="purchase_code">
                                            <?php echo e(trans('installer_messages.purchase_code.code')); ?>

                                        </label>
                                        <input type="text" name="purchase_code" id="purchase_code"
                                            placeholder="<?php echo e(trans('installer_messages.purchase_code.code')); ?>" />
                                        <?php if($errors->has('purchase_code')): ?>
                                            <span class="error-block">
                                                <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                                                <?php echo e($errors->first('purchase_code')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- section end -->
                    </div>
                </div>
                <div class="col-md-6 text-center">
                    <img src="<?php echo e(asset('installer/img/main-banner.png')); ?>" width="400" class="img-responsive">
                </div>
            </div>
            <div class="box-footer">
                <div class="pull-left">
                    <div class="form-group <?php echo e($errors->has('terms_condition') ? ' has-error ' : ''); ?>">
                        I agree with the <a href="https://ommune.com/terms" target="_blank" data-original-title=""
                            title="">Terms and Conditions</a>.
                        <input name="terms_condition" type="checkbox" value="1">
                        <br>
                        <?php if($errors->has('terms_condition')): ?>
                            <span class="error-block">
                                <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                                <?php echo e($errors->first('terms_condition')); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="pull-right mobile-center">
                    <div class="buttons">
                        <button class="btn btn-primary btn-flat verify-install" type="submit" id="submitbutton">
                            <?php echo e(trans('installer_messages.purchase_code.next')); ?>

                            <i class="fa fa-angle-right fa-fw" aria-hidden="true"></i>
                        </button>
                    </div>
                </div>
                <div class="clearfix">
                    <!-- -->
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";
        document.addEventListener('DOMContentLoaded', function() {
            // Get the purchase_code input element
            var purchaseCodeInput = document.getElementById('purchase_code');
            // Add an onchange event listener to the purchase_code input
            purchaseCodeInput.addEventListener('change', function() {
                var inputValue = purchaseCodeInput.value;
                CheckPurchaseCode(inputValue);
            });
        });

        function CheckPurchaseCode(val) {
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('purchasecodeverify')); ?>",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    purchaseCode: val
                },
                success: function(response) {
                    if (response != '') {
                        // console.log(response);
                        //$('#msgStatus').show();
                        $('.msgStatus').removeClass('d-none');
                        $('.msgStatus').text(response);
                        $('#submitbutton').attr('disabled', "disabled")
                    } else {
                        //$('#msgStatus').hide();
                        $('.msgStatus').addClass('d-none');
                        $('#submitbutton').removeAttr('disabled');
                    }
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.installer.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/BACKUP/repo/mailtidy/resources/views/vendor/installer/verify.blade.php ENDPATH**/ ?>