<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script>
        var BaseUrl = "<?php echo e(URL::to('')); ?>";
    </script>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="shortcut icon" href="<?php echo e(getLogo()['favicon']); ?>" />

    <!--begin::Vendor Stylesheets(used by this page)-->
    <?php $__currentLoopData = getVendors('css'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<link rel="stylesheet" href="%s">', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Vendor Stylesheets-->

    <!--begin::Global Stylesheets Bundle(used by all pages)-->
    <?php $__currentLoopData = getGlobalAssets('css'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<link rel="stylesheet" href="%s">', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Global Stylesheets Bundle-->

    <!--begin::Custom Stylesheets(optional)-->
    <?php $__currentLoopData = getCustomCss(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<link rel="stylesheet" href="%s">', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Custom Stylesheets-->
    <script src="<?php echo e(asset('assets/extensions/jquery/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sweetalert.js')); ?>"></script>

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;400;500;600;700;800&display=swap" rel="stylesheet">
</head>

<body data-theme-color="<?php echo e(getLogo()['themes_color']); ?>">
    <script src="<?php echo e(asset('js/loader.js')); ?>"></script>
    <script>
        "use strict";
        function sAlert(icon, title, url = '') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 1200,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            })
            if (url != "") {
                Toast.fire({
                    icon: icon,
                    title: title,
                }).then((Toast) => {
                    if (Toast) {
                        window.location.href = url;
                    }
                });
            } else {
                Toast.fire({
                    icon: icon,
                    title: title,
                })
            }
        }
    </script>

    <?php if(session('success')): ?>
        <script>
            "use strict";
            Swal.fire({
                text: "<?php echo e(session('success')); ?>",
                icon: "success",
                buttonsStyling: false,
                confirmButtonText: "Okay!",
                customClass: {
                    confirmButton: "btn btn-primary"
                }
            });
        </script>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <script>
            sAlert('error', "<?php echo e(session('error')); ?>");
        </script>
    <?php endif; ?>


    <?php echo $__env->yieldContent('content'); ?>


    <!--begin::Vendors Javascript(used by this page)-->
    <?php $__currentLoopData = getVendors('js'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<script src="%s"></script>', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Vendors Javascript-->
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <?php $__currentLoopData = getGlobalAssets(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<script src="%s"></script>', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Global Javascript Bundle-->

    <!--begin::Custom Javascript(optional)-->
    <?php $__currentLoopData = getCustomJs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo sprintf('<script src="%s"></script>', asset($path)); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!--end::Custom Javascript-->
</body>

</html>
<?php /**PATH /Volumes/BACKUP/repo/mailtidy/resources/views/layouts/app.blade.php ENDPATH**/ ?>